/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.DoorbellBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.FurnitureScreens;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DoorbellBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    public DoorbellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)14.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> VoxelShapeHelper.rotateHorizontally(baseShape, (Direction)state.m_61143_((Property)DIRECTION)))));
    }

    @Override
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ENABLED) != false ? 16 : 0;
    }

    @Override
    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)DIRECTION);
        BlockPos relativePos = pos.m_121945_(facing);
        return reader.m_8055_(relativePos).m_60783_((BlockGetter)reader, relativePos, facing.m_122424_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState relativeState, LevelAccessor level, BlockPos pos, BlockPos relativePos) {
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, relativeState, level, pos, relativePos);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            if (!level.m_5776_()) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof DoorbellBlockEntity) {
                    DoorbellBlockEntity doorbell = (DoorbellBlockEntity)blockEntity;
                    doorbell.setOwner(entity.m_20148_());
                }
            } else {
                FurnitureScreens.openNameableScreen(pos, (Component)Utils.translation("gui", "set_doorbell_name", new Object[0]), 32);
            }
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        if (face.m_122434_().m_122479_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)face.m_122424_());
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        DoorbellBlockEntity doorbell;
        if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DoorbellBlockEntity && (doorbell = (DoorbellBlockEntity)blockEntity).isNodePowered()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)), 3);
            level.m_186460_(pos, (Block)this, 20);
            level.m_247517_(null, pos, (SoundEvent)ModSounds.BLOCK_DOORBELL_CHIME.get(), SoundSource.BLOCKS);
            level.m_46717_(pos, (Block)this);
            doorbell.sendNotificationToOwner(player);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 3);
            level.m_46717_(pos, (Block)this);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENABLED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DoorbellBlockEntity(pos, state);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_);
    }
}

